SCROLLSTEP=2
NOSPR=10
NOSPR32=9
NOBLK EQU (BGXSLUT-BLOCKGX)/512
BLOCKHITNR=NOBLK+1    ;LOWEST COLLISION BLOCK NR
SCR=$F8000      ;$78000!!!
SCR1=$F0000

 BRA START
BUFF:
 DS.B 3000,0

START:
 CLR.L -(SP)     ;SV MODE
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 MOVE.W #0,$484

 PEA MOUSE
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 BSR FIXSPRITES

 LEA SCR1,A0
 MOVE.W #15999,D0
CLS:
 CLR.L (A0)+
 DBRA D0,CLS
 LEA TEMP,A0
 MOVE.W #15999,D0
CLS2:
 CLR.L (A0)+
 DBRA D0,CLS2

 MOVE.W #$2700,SR
 MOVE.L $68,OHBL
 MOVE.L #SAMPLAY,$68
 BSR SETSND
 MOVE.L $118,OKEY
 MOVE.L #JOYSTICK,$118
 MOVE.L $70,OVBL
 MOVE.L #VBL,$70
 MOVE.W #$2100,SR

 BRA MAIN

EXIT:
 MOVE.W #$2700,SR
FLUSH:
 BTST #0,$FFFC00          ;IS A CHARACTER WAITING ?
 BEQ.S FL1                ;BR. IF NOT
 MOVE.B $FFFC02,D0        ;READ CHARACTER (& IGNORE IT)
 BRA.S FLUSH              ;CHECK FOR ANOTHER
FL1:
 MOVE.L OHBL,$68
 MOVE.L OVBL,$70
 MOVE.L OKEY,$118
 MOVE.W #$2300,SR

 MOVE.W #1,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 ILLEGAL
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS

VBL2:
 ST SYNCF
 BRA VB22
VBL:
 MOVE.W #$000,$FF8240
 MOVE.B SCREENS+1,$FF8201
 MOVE.B SCREENS+2,$FF8203
 MOVE.L #VBL2,$70
VB22:
 MOVEM.L D0/A0,-(SP)

 CMP.L #SAMPSLUT,A6
 BLO SAMPSKIP
 SUB.L #SAMPSLUT-SAMPLE,A6
SAMPSKIP:

 MOVEM.L (SP)+,D0/A0
 ADDQ.W #1,CLOCK
 CMP.B #$66,$FFFC02
 BEQ EXIT
 RTE

MAIN:

SYNC:
 TST.B SYNCF
 BEQ SYNC

 CLR.B SYNCF
 LEA SCREENS,A0
 ADD.B #$80,2(A0)
 MOVE.L #VBL,$70

 BSR GETDOWN     ;UPDATE SCROLL
 BSR CANNONS     ;UPDATE CANNONS
 BSR SHOTS       ;UPDATE SHOTS
 BSR SPRITES     ;UPDATE SPRITES
 BSR CHECKCOLLISIONS
 BSR WAVEUPDAT   ;UPDATE ATTACK WAVES

 BRA MAIN
SYNCF:
 DC.W 0

;***************************************
;** ROUTINE FOR UPDATING ATTACK WAVES **
;***************************************
WAVEUPDAT:
 TST.B WVFLAG
 BEQ WV1
 TST.W WVWAITCOUNT
 BEQ WVPEK1
   SUBQ.W #1,WVWAITCOUNT
   RTS
WVPEK1:    ;PEK!!!
 LEA WAVE1,A0
 MOVE.W (A0)+,D0   ;COMMAND
 BEQ WVEND
 CMP.B #1,D0
 BEQ WVI16
 CMP.B #2,D0
 BEQ WVI32
 CMP.B #3,D0
 BEQ WVWAIT
WV2:
 MOVE.L A0,WVPEK1+2
WV1:
 RTS

WVI16:             ;INSERT A 16*16 SPRITE
 LEA SPRITELIST,A1
 MOVEQ #16,D1
 MOVEQ #7,D0
WVI161:
 ADD.W D1,A1
 TST.L (A1)
 DBEQ D0,WVI161
 TST.W D0
 BMI WVI162
 MOVE.L (A0)+,(A1)+ ;STYRRUTIN
 MOVE.L (A0)+,(A1)+ ;MOVEMENT TABEL
 MOVE.L (A0)+,(A1)+ ;SPRITE GRAF
 MOVE.L #0,(A1)     ;Y X COORDS
 BRA WV2
WVI162:
 ADD.W #12,A0
 BRA WV2

WVI32:              ;INSERT A 32*32 SPRITE
 LEA SPRITELIST32-18,A1
 MOVEQ #18,D1
 MOVEQ #3,D0
WVI321:
 ADD.W D1,A1
 TST.L (A1)
 DBEQ D0,WVI321
 TST.W D0
 BMI WVI322
 MOVE.L (A0)+,(A1)+ ;STYRRUTIN
 MOVE.L (A0)+,(A1)+ ;MOVEMENT TABEL
 MOVE.L (A0)+,(A1)+ ;SPRITE GRAF
 MOVE.L #$00000004,(A1)+    ;Y X COORDS
 MOVE.W (A0)+,(A1)  ;HITS
 BRA WV2
WVI322:
 ADD.W #14,A0
 BRA WV2

WVWAIT:            ;WAIT
 MOVE.W (A0)+,WVWAITCOUNT
 BRA WV2

WVEND:             ;END WAVE
 CLR.B WVFLAG
 RTS
WVWAITCOUNT:
 DC.W 0
WVFLAG:
 DC.W 0
;***************************************
;** END OF ATTACK WAVE UPDATE         **


;***************************************
;** ROUTINE FOR SPRITE COLLISION      **
;***************************************
CHECKCOLLISIONS:
 BSR CHECKCOL1     ;HERO  VS OBSTACLES
 BSR CHECKCOL2     ;SHOTS VS 16*16 BADDIES
 BSR CHECKCOL3     ;SHOTS VS 32*32 BADDIES
 RTS

CHECKCOL1:         ;CHECK COLLISION: HERO VS GROUND OBSTACLES. UPDATE OBST Y.
 LEA SPRITELIST+12,A0
 MOVE.W (A0)+,D6   ;HERO Y
 MOVE.W (A0)+,D7   ;HERO X
 LEA OBSTXY,A0

 MOVEQ #13,D5
CHC1:
 MOVE.W (A0)+,D0
 BEQ CHC7          ;NOT ACTIVE
 MOVE.L (A0),D0    ;OBST XY
 SWAP D0
 MOVE.L D0,D1

 SUB.W D6,D1
 ADD.W #32*160,D1
 BMI.S CHC3          ;NO COLL
 CMP.W #48*160,D1
 BGE.S CHC3          ;NO COLL

 SWAP D1

 SUB.W D7,D1
 ADDQ.W #8,D1
 BMI.S CHC3          ;NO COLL
 CMP.W #12,D1
 BGE.S CHC3          ;NO COLL

 NOP
; MOVE.W #$700,$FF8240  ;COLLISION=TRUE
; MOVE.W #$000,$FF8240
CHC3:              ;COLLISION=FALSE
 CMP.W #190*160,D0
 BGE CHC8
 ADD.W #160*2,D0
 MOVE.W D0,(A0)

CHC7:
 ADDQ.W #4,A0
 DBRA D5,CHC1

 RTS
CHC8:              ;REMOVE
 MOVE.W #0,-2(A0)  ;NOT ACTIVE
 BRA.S CHC7


CHECKCOL2:         ;CHECK COLLISION: HERO SHOTS VS 16*16 BADDIES
 LEA SPRITELIST+16,A1
 MOVEQ #7,D4
CHC22:
 TST.L (A1)
 BEQ CHC24
   CMP.L #STYREX,(A1)
   BEQ CHC24
   MOVE.W 12(A1),D6 ;BAD Y
   MOVE.W 14(A1),D7 ;BAD X
   BRA.S CHC28
CHC29:
   TST.W D5
   BMI.S CHC24
     MOVE.L #STYREX,(A1) ;TRIGG AN EXPLOSION
     MOVE.L #EX16TAB,4(A1)
     MOVE.L #SPRITEGX+(12*384),8(A1)
CHC24:
 ADD.W #16,A1
 DBRA D4,CHC22
 RTS
CHC28:
 LEA SHOTLIST,A0
 MOVEQ #11,D5
CHC21:
 TST.W (A0)
 BEQ.S CHC27          ;NOT ACTIVE
 MOVE.L 2(A0),D1      ;SHOT XY
 SWAP D1

 SUB.W D6,D1
 ADD.W #4*160,D1
 BMI.S CHC27          ;NO COLL
 CMP.W #20*160,D1
 BGE.S CHC27          ;NO COLL

 SWAP D1

 SUB.W D7,D1
 ADDQ.W #2,D1
 BMI.S CHC27        ;NO COLL
 CMP.W #6,D1
 BGE.S CHC27        ;NO COLL
 MOVE.W #0,(A0)     ;COLLISION=TRUE. REMOVE SHOT
 BRA CHC29
CHC27:              ;COLLISION=FALSE
 ADDQ.W #6,A0
 DBRA D5,CHC21
 BRA CHC29


CHECKCOL3:         ;CHECK COLLISION: HERO SHOTS VS 32*32 BADDIES
 LEA SPRITELIST32,A1
 MOVEQ #3,D4
CHC32:
 TST.L (A1)
 BEQ.S CHC34
  CMP.L #STYREX,(A1)
  BEQ.S CHC34
   MOVE.W 12(A1),D6 ;BAD Y
   MOVE.W 14(A1),D7 ;BAD X
   BRA.S CHC38
CHC39:
   TST.W D5
   BMI.S CHC34
     SUBQ.W #1,16(A1) ;SUFFICENT HITS?
     BPL.S CHC34        ;NO
       MOVE.L #STYREX,(A1) ;TRIGG AN EXPLOSION
       MOVE.L #EX32TAB,4(A1)
       MOVE.L #SPRITEGX32+(4*1152),8(A1)
CHC34:
 ADD.W #18,A1
 DBRA D4,CHC32
 RTS
CHC38:
 LEA SHOTLIST,A0
 MOVEQ #11,D5
CHC31:
 TST.W (A0)
 BEQ.S CHC37         ;NOT ACTIVE
 MOVE.L 2(A0),D1     ;SHOT XY
 SWAP D1

 SUB.W D6,D1
 ADD.W #4*160,D1    ;SHOT HEIGHT
 BMI.S CHC37        ;NO COLL
 CMP.W #36*160,D1   ;SHOT HEIGHT+SPRITE HEIGHT
 BGE.S CHC37        ;NO COLL

 SWAP D1

 SUB.W D7,D1
 ADDQ.W #2,D1       ;SHOT WIDTH
 BMI.S CHC37        ;NO COLL
 CMP.W #10,D1       ;SHOT WIDTH+SPRITE WIDTH
 BGE.S CHC37        ;NO COLL
 MOVE.W #0,(A0)     ;COLLISION=TRUE. REMOVE SHOT
 BRA CHC39
CHC37:              ;COLLISION=FALSE
 ADDQ.W #6,A0
 DBRA D5,CHC31
 BRA CHC39
;*************************************
;** END OF SPRITE COLLISION ROUTINE **


;*************************************
;** ROUTINE FOR SCROLLER UPDATE     **
;*************************************
GETDOWN:
 LEA BADDS,A2
GPEK2:
 MOVEQ #32/2,D0
 BNE GG3
 MOVE.B #32/2,GPEK2+1
GPEK3:
 LEA BLOCKS,A0        ;PLACE NEW BLOCKS
 CMP.L #BLOCKSLUT,A0
 BNE GG4
 LEA BLOCKS,A0
GG4:
 MOVEQ #9,D1
 LEA BLOCKGX,A3
 MOVEQ #4,D7          ;OBST. X FACTOR
 MOVEQ #5,D2
GG5:
 CLR.L D0
 MOVE.B (A0)+,D0
 BPL GG10

  MOVE.W D0,D3        ;INSERT CANNON
  NEG.B D3
  LSL.W #3,D3
  LEA CANNSPECS,A5
  ADD.W D3,A5
  MOVEQ #9,D4
  LEA CANNTAB-16,A4      ;FIND FREE
GG11:
  ADD.W #16,A4
  TST.W (A4)
  DBEQ D4,GG11
  TST.W D4
  BMI GG10               ;NONE FOUND
  MOVE.W (A5)+,(A4)+     ;HITS
  MOVE.W (A5)+,(A4)+     ;SHOTS
  MOVE.L (A5)+,(A4)+     ;GX
  MOVE.W #-(32*160),(A4)+ ;Y ADD
  MOVE.W D7,(A4)+        ;X COORD
  CLR.W D0

GG10:
 CMP.B #BLOCKHITNR,D0
 BLO GG7

  LEA OBSTXY-6,A4       ;INSERT OBSTACLE
  MOVEQ #13,D3
GG8:
  ADDQ.W #6,A4
  TST.W (A4)           ;FIND FREE
  DBEQ D3,GG8
  TST.W D3
  BMI GG7             ;NONE FOUND
  MOVE.W #-1,(A4)+    ;TAG ACTIVE
  MOVE.W #-(32*160),(A4)+  ;Y VALUE
  MOVE.W D7,(A4)+     ;X VALUE

GG7:
 LSL.L D1,D0
 LEA (A3,D0.L),A4
 MOVE.L A4,(A2)+
 ADDQ.W #8,D7
 DBRA D2,GG5

  CLR.W D0
  MOVE.B (A0)+,D0      ;ATTACK WAVE
  BEQ GG9
  CMP.B #2,D0
  BGE GG9
  TST.B WVFLAG
  BNE GG9
  LSL.W #2,D0
  LEA WAVEADDS,A4
  MOVE.L (A4,D0.W),WVPEK1+2
  ST WVFLAG

GG9:
 MOVE.L A0,GPEK3+2
 LEA BADDS,A2
GG3:
 SUBQ.B #1,GPEK2+1

GPEK1:
 LEA TEMP+(200*96),A1
 CMP.L #TEMP,A1
 BNE GG1
 MOVE.L #TEMP+(200*96),GPEK1+2
GG1:
 SUB.L #96*2,GPEK1+2          ;SCROLL

L@=0
N@=0
 REPEAT
 MOVE.L (A2),A0
 MOVEM.L (A0)+,D0-D7
 MOVEM.L D0-D3,96+L@(A1)
 MOVEM.L D0-D3,19296+L@(A1)
 MOVEM.L D4-D7,L@(A1)
 MOVEM.L D4-D7,19200+L@(A1)
 MOVE.L A0,(A2)+
N@=N@+1
L@=L@+16
 UNTILEQ N@,6

 MOVE.L A1,A0         ;MOVE DOWN TO SCREEN
 MOVE.L SCREENS,A1
L@=0
N@=0
 REPEAT
  MOVEM.L (A0)+,D0-D7/A2-A5
  MOVEM.L D0-D7/A2-A5,L@(A1)
  MOVEM.L (A0)+,D0-D7/A2-A5
  MOVEM.L D0-D7/A2-A5,L@+48(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,200

 RTS
WAVEADDS:
 DC.L 0,WAVE1,WAVE2
;************************************
;** END OF SCROLLER UPDATE ROUTINE **


;************************************
;** SHOTS UPDATE ROUTINE           **
;************************************
SHOTS:
 LEA SHOTLIST,A5
 MOVEQ #11,D7
SH1:
 JSR SHOT
 DBRA D7,SH1
 RTS
KILLSHOT:
 MOVE.W #0,-2(A5) ;FLAG: NOT ACTIVE
NEXTSHOT:
 ADDQ.W #4,A5
 RTS
SHOT:
 MOVE.W (A5)+,D0 ;MOVEMENT FACTOR
 BEQ NEXTSHOT
 SUB.W #14*160,(A5)
 TST.W (A5)
 BMI KILLSHOT
 MOVE.L SCREENS,A2
 ADD.W (A5)+,A2  ;Y COORD*160
 MOVE.W (A5)+,D0 ;X COORD
 SUBQ.W #4,D0
 MOVE.W D0,D1
 AND.B #%11111100,D0
 LSL.W #1,D0
 ADD.W D0,A2
 MOVE.L A2,A3
 AND.W #3,D1
 LSL.W #3,D1
 LEA SHOTGX,A0
 LEA SHOTADDS,A4
 ADD.W D1,A4
 ADD.W (A4)+,A2
 ADD.W (A4)+,A3
 ADD.W (A4)+,A0
 LEA 16(A0),A1

 MOVE.B (A0)+,D0
 MOVE.B (A0)+,D1
 AND.B D0,(A2)
 AND.B D0,2(A2)
 AND.B D0,4(A2)
 AND.B D0,6(A2)
 OR.B D1,6(A2)
 MOVE.B (A1)+,D0
 MOVE.B (A1)+,D1
 AND.B D0,(A3)
 AND.B D0,2(A3)
 AND.B D0,4(A3)
 AND.B D0,6(A3)
 OR.B D1,6(A3)
 MOVE.B (A0)+,D0
 MOVE.B (A0)+,D1
 MOVE.B (A1)+,D2
 MOVE.B (A1)+,D3
N@=0
L@=160
 REPEAT
  AND.B D0,L@(A2)
  AND.B D0,2+L@(A2)
  AND.B D0,4+L@(A2)
  AND.B D0,6+L@(A2)
  OR.B D1,6+L@(A2)
  AND.B D2,L@(A3)
  AND.B D2,2+L@(A3)
  AND.B D2,4+L@(A3)
  AND.B D2,6+L@(A3)
  OR.B D3,6+L@(A3)
L@=L@+160
N@=N@+1
 UNTILEQ N@,3
 RTS
SHOTADDS:
 DC.W 0,1,0,0, 0,1,32,0, 1,8,0,0, 1,8,32,0
;************************************
;** END OF SHOTS UPDATE ROUTINE    **
;************************************

;************************************
;** SPRITE UPDATE ROUTINE          **
;************************************
SPRITES:
 MOVE.B #9,SPRRS    ;DRAW 16*16 SPRITES
 LEA SPRITELIST,A0
SPLOP:
 TST.L (A0)
 BEQ SPRNO2
 BSR SPRITE
SPRNO:
 SUBQ.B #1,SPRRS
 BNE SPLOP

 MOVE.B #4,SPRRS    ;DRAW 32*32 SPRITES
 LEA SPRITELIST32,A0
SPLOP2:
 TST.L (A0)
 BEQ SPRNO3
 BSR SPRITE32
SPRNO4:
 SUBQ.B #1,SPRRS
 BNE SPLOP2
 RTS
SPRNO2:
 LEA 16(A0),A0
 BRA SPRNO
SPRNO3:
 LEA 18(A0),A0
 BRA SPRNO4
SPRRS:
 DC.W 0

SPRADDS:
 DC.W 0,384,384*2,384*3

SPRITE:
 MOVE.L (A0)+,A1  ;STYR
 JSR (A1)
 MOVE.L (A0)+,D0  ;STYR FAKTOR
 MOVE.L (A0)+,A2  ;GRAFX
 MOVE.L SCREENS,A1
 MOVE.W (A0)+,D0  ;Y COORD*160
 BMI CLIPTOP
 CMP.W #184*160,D0
 BGE CLIPBOTTOM
 ADD.W D0,A1
 MOVE.W (A0)+,D0  ;X COORD/4
 CMP.W #4,D0
 BLO CLIPLEFT
 SUBQ.W #4,D0
 CMP.W #44,D0
 BGE CLIPRIGHT
 MOVE.W D0,D1
 AND.B #%11111100,D0
 LSL.W #1,D0
 ADD.W D0,A1
 AND.W #3,D1
 LSL.W #1,D1
 LEA SPRADDS(PC),A3
 ADD.W (A3,D1.W),A2

L@=0
N@=0
 REPEAT
  MOVE.L (A2)+,D7
  MOVEM.L L@(A1),D0-D3
  AND.L D7,D0
  OR.L (A2)+,D0
  AND.L D7,D1
  OR.L (A2)+,D1
  MOVE.L (A2)+,D7
  AND.L D7,D2
  OR.L (A2)+,D2
  AND.L D7,D3
  OR.L (A2)+,D3
  MOVEM.L D0-D3,L@(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,16
 RTS
CLIPLEFT:
 AND.W #3,D0
 LSL.W #1,D0
 LEA SPRADDS(PC),A3
 ADD.W (A3,D0.W),A2

 MOVEQ #12,D0
L@=0
N@=0
 REPEAT
  ADD.W D0,A2
  MOVEM.L L@(A1),D2-D3
  MOVE.L (A2)+,D7
  AND.L D7,D2
  OR.L (A2)+,D2
  AND.L D7,D3
  OR.L (A2)+,D3
  MOVEM.L D2-D3,L@(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,16
 RTS

CLIPRIGHT:
 ADD.W #88,A1
 AND.W #3,D0
 LSL.W #1,D0
 LEA SPRADDS(PC),A3
 ADD.W (A3,D0.W),A2

 MOVEQ #12,D0
L@=0
N@=0
 REPEAT
  MOVEM.L L@(A1),D2-D3
  MOVE.L (A2)+,D7
  AND.L D7,D2
  OR.L (A2)+,D2
  AND.L D7,D3
  OR.L (A2)+,D3
  MOVEM.L D2-D3,L@(A1)
  ADD.W D0,A2
L@=L@+160
N@=N@+1
 UNTILEQ N@,16
 RTS
CLIPTOP:
 MOVE.W (A0)+,D1  ;X COORD/4
 SUBQ.W #4,D1
 MOVE.W D1,D2
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A1
 AND.W #3,D2
 LSL.W #1,D2
 LEA SPRADDS(PC),A3
 ADD.W (A3,D2.W),A2

 MOVEQ #15,D4
CTOP1:
 ADD.W #384/16,A2
 ADD.W #160,D0
 DBPL D4,CTOP1
 TST.W D4
 BMI CTOP2

CTOP3:
 MOVE.L (A2)+,D7
 MOVEM.L (A1),D0-D3
 AND.L D7,D0
 OR.L (A2)+,D0
 AND.L D7,D1
 OR.L (A2)+,D1
 MOVE.L (A2)+,D7
 AND.L D7,D2
 OR.L (A2)+,D2
 AND.L D7,D3
 OR.L (A2)+,D3
 MOVEM.L D0-D3,(A1)
 LEA 160(A1),A1
 DBRA D4,CTOP3

CTOP2:
 RTS
CLIPBOTTOM:
 MOVE.W (A0)+,D1  ;X COORD/4
 SUBQ.W #4,D1
 MOVE.W D1,D2
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A1
 AND.W #3,D2
 LSL.W #1,D2
 LEA SPRADDS(PC),A3
 ADD.W (A3,D2.W),A2
 ADD.W D0,A1

 SUB.W #183*160,D0
 MOVEQ #15,D4
CBOT1:
 SUB.W #160,D0
 DBEQ D4,CBOT1
 TST.W D4
 BMI CBOT2

CBOT3:
 MOVE.L (A2)+,D7
 MOVEM.L (A1),D0-D3
 AND.L D7,D0
 OR.L (A2)+,D0
 AND.L D7,D1
 OR.L (A2)+,D1
 MOVE.L (A2)+,D7
 AND.L D7,D2
 OR.L (A2)+,D2
 AND.L D7,D3
 OR.L (A2)+,D3
 MOVEM.L D0-D3,(A1)
 LEA 160(A1),A1
 DBRA D4,CBOT3
CBOT2:
 RTS

SPRADDS32:
 DC.W 0,1152,1152*2,1152*3
SPRITE32:
 MOVE.L (A0)+,A1  ;STYR
 JSR (A1)
 MOVE.L (A0)+,D0  ;STYRFAKTOR
 MOVE.L (A0)+,A2  ;GRAFX
 MOVE.L SCREENS,A1
 MOVE.W (A0)+,D0  ;Y COORD*160
 BMI CLIPTOP32
 CMP.W #168*160,D0
 BGE CLIPBOTTOM32
 ADD.W D0,A1
 MOVE.W (A0)+,D0  ;X COORD/4
 ADDQ.W #2,A0     ;HITS
; CMP.W #4,D0
; BLO CLIPLEFT32
 SUBQ.W #4,D0
; CMP.W #44,D0
; BGE CLIPRIGHT32
 MOVE.W D0,D1
 AND.B #%11111100,D0
 LSL.W #1,D0
 ADD.W D0,A1
 AND.W #3,D1
 LSL.W #1,D1
 LEA SPRADDS32(PC),A3
 ADD.W (A3,D1.W),A2

L@=0
N@=0
 REPEAT
  MOVE.L (A2)+,D7
  MOVEM.L L@(A1),D0-D5
  AND.L D7,D0
  OR.L (A2)+,D0
  AND.L D7,D1
  OR.L (A2)+,D1
  MOVE.L (A2)+,D7
  AND.L D7,D2
  OR.L (A2)+,D2
  AND.L D7,D3
  OR.L (A2)+,D3
  MOVE.L (A2)+,D7
  AND.L D7,D4
  OR.L (A2)+,D4
  AND.L D7,D5
  OR.L (A2)+,D5
  MOVEM.L D0-D5,L@(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,32
 RTS
CLIPTOP32:
 MOVE.W (A0)+,D1  ;X COORD/4
 ADDQ.W #2,A0     ;HITS
 SUBQ.W #4,D1
 MOVE.W D1,D2
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A1
 AND.W #3,D2
 LSL.W #1,D2
 LEA SPRADDS32(PC),A3
 ADD.W (A3,D2.W),A2

 MOVEQ #31,D6
CTOP132:
 ADD.W #1152/32,A2
 ADD.W #160,D0
 DBPL D6,CTOP132
 TST.W D6
 BMI CTOP232

CTOP332:
 MOVE.L (A2)+,D7
 MOVEM.L (A1),D0-D5
 AND.L D7,D0
 OR.L (A2)+,D0
 AND.L D7,D1
 OR.L (A2)+,D1
 MOVE.L (A2)+,D7
 AND.L D7,D2
 OR.L (A2)+,D2
 AND.L D7,D3
 OR.L (A2)+,D3
 MOVE.L (A2)+,D7
 AND.L D7,D4
 OR.L (A2)+,D4
 AND.L D7,D5
 OR.L (A2)+,D5
 MOVEM.L D0-D5,(A1)
 LEA 160(A1),A1
 DBRA D6,CTOP332

CTOP232:
 RTS
CLIPBOTTOM32:
 MOVE.W (A0)+,D1  ;X COORD/4
 ADDQ.W #2,A0     ;HITS
 SUBQ.W #4,D1
 MOVE.W D1,D2
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A1
 AND.W #3,D2
 LSL.W #1,D2
 LEA SPRADDS32(PC),A3
 ADD.W (A3,D2.W),A2
 ADD.W D0,A1

 SUB.W #167*160,D0
 MOVEQ #31,D6
CBOT132:
 SUB.W #160,D0
 DBEQ D6,CBOT132
 TST.W D6
 BMI CBOT232

CBOT332:
 MOVE.L (A2)+,D7
 MOVEM.L (A1),D0-D5
 AND.L D7,D0
 OR.L (A2)+,D0
 AND.L D7,D1
 OR.L (A2)+,D1
 MOVE.L (A2)+,D7
 AND.L D7,D2
 OR.L (A2)+,D2
 AND.L D7,D3
 OR.L (A2)+,D3
 MOVE.L (A2)+,D7
 AND.L D7,D4
 OR.L (A2)+,D4
 AND.L D7,D5
 OR.L (A2)+,D5
 MOVEM.L D0-D5,(A1)
 LEA 160(A1),A1
 DBRA D6,CBOT332
CBOT232:
 RTS
;************************************
;** END OF SPRITES UPDATE          **


;************************************
;** CANNONS UPDATE ROUTINES        **
;************************************
CANNONS:
 LEA CANNTAB,A0
 MOVEQ #9,D0
C2:
 TST.W (A0)
 BEQ C1
  MOVE.W D0,-(SP)
  BSR CANNON
  MOVE.W (SP)+,D0
C3:
 DBRA D0,C2
 RTS

C1:
 LEA 16(A0),A0
 BRA C3
CANNON:
 MOVE.L SCREENS,A2
 ADDQ.W #4,A0
 MOVE.L (A0)+,A1   ;GX
 MOVE.W (A0),D0    ;Y ADD
 CMP.W #168*160,D0
 BGE CLIPBOTTOMC
 ADD.W #SCROLLSTEP*160,D0
 MOVE.W D0,(A0)+
 TST.W D0
 BMI CLIPTOPC
 ADD.W D0,A2
 MOVE.W (A0)+,D0   ;X COORD
 SUBQ.W #4,D0
 ADDQ.W #4,A0
 AND.B #%11111100,D0
 LSL.W #1,D0
 ADD.W D0,A2

L@=0
N@=0
 REPEAT
  MOVEM.L (A1)+,D0-D7
  MOVEM.L D0-D3,L@(A2)
  MOVEM.L D4-D7,L@+160(A2)
L@=L@+320
N@=N@+1
 UNTILEQ N@,16
 RTS

CLIPTOPC:
 MOVE.W (A0)+,D1   ;X COORD
 SUBQ.W #4,D1
 ADDQ.W #4,A0
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A2

 MOVEQ #31,D6
C6:
 ADD.W #16,A1
 ADD.W #160,D0
 DBPL D6,C6
 TST.W D6
 BMI C7

C8:
 MOVEM.L (A1)+,D0-D3
 MOVEM.L D0-D3,(A2)
 LEA 160(A2),A2
 DBRA D6,C8
C7:
 RTS

CLIPBOTTOMC:
 CMP.W #200*160,D0
 BGE C4
   CLR.W -8(A0)    ;KILL CANNON
   ADDQ.W #8,A0
   BRA C5
C4:
 ADD.W #SCROLLSTEP*160,D0
 MOVE.W D0,(A0)+
 MOVE.W (A0)+,D1   ;X COORD
 SUBQ.W #4,D1
 ADDQ.W #4,A0
 AND.B #%11111100,D1
 LSL.W #1,D1
 ADD.W D1,A2

 SUB.W #167*160,D0
 MOVEQ #31,D6
C9:
 SUB.W #160,D0
 DBEQ D6,C9
 TST.W D6
 BMI C7

C10:
 MOVEM.L (A1)+,D0-D3
 MOVEM.L D0-D3,(A2)
 LEA 160(A2),A2
 DBRA D6,C10
C5:
 RTS

;************************************
;** END OF CANNONS ROUTS           **


;************************************
;** INITIALIZE ROUTINE             **
;************************************
FIXSPRITES:
 BSR FIXSUB32       ;FIX THE 32*32 SPRITES
 LEA SPRITEGX,A6
 LEA TEMP,A5
 MOVE.W #NOSPR-1,D7
FF8:
 MOVE.L A6,A3     ;ROTATE SPRITES
 MOVE.L A5,A4
 MOVEQ #0,D5
 MOVEQ #3,D6
FF4:
 MOVE.L A3,A0
 MOVE.L A4,A1
 BSR FIXSUB
 ADD.W #320,A4
 ADDQ.W #4,D5
 DBRA D6,FF4
 ADD.W #160,A6
 ADD.W #4*320,A5
 DBRA D7,FF8
 LEA TEMP,A0
 LEA SPRITEGX,A1
 MOVE.W #((NOSPR*(4*320))/4)-1,D0
 BSR COPY

 LEA SPRITEGX,A0
 LEA TEMP,A1
 MOVE.W #((NOSPR*4)*16)-1,D2
FF1:
 MOVE.W (A0)+,D0
 MOVE.W D0,D1
 SWAP D1
 MOVE.W D0,D1
 MOVE.L D1,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+

 MOVE.W (A0)+,D0
 MOVE.W D0,D1
 SWAP D1
 MOVE.W D0,D1
 MOVE.L D1,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 DBRA D2,FF1

 LEA TEMP,A0
 LEA SPRITEGX,A1
 MOVE.W #((NOSPR*(4*384))/4)-1,D0
 BSR COPY

 LEA BLOCKGX,A3    ;FLIP BLOCKS
 MOVE.W #NOBLK-1,D2
FF7:
 MOVE.L A3,A0
 LEA TEMP+512-16,A1
 MOVEQ #31,D0
FF6:
 MOVE.L (A0)+,(A1)
 MOVE.L (A0)+,4(A1)
 MOVE.L (A0)+,8(A1)
 MOVE.L (A0)+,12(A1)
 SUB.W #16,A1
 DBRA D0,FF6
 LEA TEMP,A0
 MOVE.L A3,A1
 MOVE.W #(512/4)-1,D0
 BSR COPY
 ADD.W #512,A3
 DBRA D2,FF7
 RTS

FIXSUB:
 MOVEQ #15,D2
FF2:
 CLR.L D0
 MOVE.W (A0)+,D0
 NOT.W D0
 SWAP D0
 LSR.L D5,D0
 NOT.L D0
 MOVE.W D0,10(A1)
 SWAP D0
 MOVE.W D0,(A1)+
 MOVEQ #3,D3
FF3:
 MOVEQ #0,D0
 MOVE.W (A0)+,D0
 SWAP D0
 LSR.L D5,D0
 MOVE.W D0,10(A1)
 SWAP D0
 MOVE.W D0,(A1)+
 DBRA D3,FF3
 ADD.W #10,A1
 DBRA D2,FF2
 RTS

FIXSUB32:
 LEA SPRITES32,A0
 LEA SPRITEGX32,A1
 MOVEQ #NOSPR32-1,D0
FI321:
  MOVEQ #31,D1
FI322:
   MOVE.W (A0),(A1)+  ;MASK
   MOVE.W (A0)+,(A1)+ ;MASK COPY
   MOVE.L (A0)+,(A1)+
   MOVE.L (A0)+,(A1)+
   MOVE.W (A0),(A1)+  ;MASK
   MOVE.W (A0)+,(A1)+ ;MASK COPY
   MOVE.L (A0)+,(A1)+
   MOVE.L (A0)+,(A1)+
   MOVE.W #-1,(A1)+
   MOVE.W #-1,(A1)+
   CLR.L (A1)+
   CLR.L (A1)+
  DBRA D1,FI322
  ADD.W #3*1152,A1
 DBRA D0,FI321

 LEA SPRITEGX32,A3
 LEA 1152(A3),A4
 MOVEQ #NOSPR32-1,D6
FI328:
 MOVE.W #2,D3
FI327:
   MOVE.L A3,A0
   MOVE.L A4,A1
   MOVE.W #(1152/4)-1,D0
   BSR COPY
  MOVE.L A4,A0
  MOVEQ #31,D2
FI326:
  MOVEQ #3,D5
FI323:                ;ROTATE MASK
   MOVE #%11111111,CCR
   ROXR.W (A0)
   ROXR.W 12(A0)
   ROXR.W 24(A0)
  DBRA D5,FI323
  MOVE.W (A0),2(A0)    ;DUPLICATE MASK
  MOVE.W 12(A0),14(A0)
  MOVE.W 24(A0),26(A0)
  ADDQ.W #4,A0
   MOVEQ #3,D0
FI324:
    MOVEQ #3,D1
FI325:
    MOVE #0,CCR
    ROXR.W (A0)
    ROXR.W 12(A0)
    ROXR.W 24(A0)
    DBRA D1,FI325
   ADDQ.W #2,A0
   DBRA D0,FI324
  ADD.W #24,A0
  DBRA D2,FI326
  ADD.W #1152,A3
  ADD.W #1152,A4
 DBRA D3,FI327
 ADD.W #1152,A3
 ADD.W #1152,A4
 DBRA D6,FI328
 RTS
;************************************
;** END OF INITIALIZE ROUT         **

;************************************
;** SAMPLE ROUTINES                **
;************************************
PREPARE:
 LEA SAMPLE,A2
AGAIN1:
 CMP.L #sampslut,A2
 BEQ FINI
 CLR.W D1
 MOVE.B (A2),D1
 ADD.B #$80,D1          ;COMPLENT VALUE
 MOVE.B D1,(A2)+
 BRA AGAIN1
FINI:
 RTS

MUSIC:
MFP=$FFFA00
IERA=$07
IERB=$09
IPRA=$0B
ISRA=$0F
IMRA=$13
IMRB=$15
VECTOR=$17
TACR=$19
TADR=$1F
ISRVEC=$134
 BSR SAVEMFP      ;SAVE NATURAL MFP CONDITIONS
 MOVE.W #$2700,SR ;INTERRUPTS OFF
 LEA ZILCH,A0
 BSR SETINT       ;SET NULL INTERRUPT ADDRESS
 JSR SETSND
 MOVEQ #1,D0      ;SET INITIAL FREQUENCY 7.5 KHZ
 BSR SETFREQ
 BSR ENABMFP      ;SET THE MFP RUNNING
 BSR SETSND       ;SET UP SOUND REGISTERS
 MOVE.W #$2500,SR ;ENABLE LEVEL 6 INTERRUPTS
 LEA SAMPLAY,A0   ;SET UP THE OUTPUT CODE ADDRESS
 LEA SAMPLE,A6    ;SET SAMPLE START
 BSR SETINT       ;GO TO IT
 RTS
SAVEMFP:
 MOVE.L #MFP,A0
 MOVE.B IERA(A0),MFPMEM
 MOVE.B IERB(A0),MFPMEM+1
 MOVE.B IMRA(A0),MFPMEM+2
 MOVE.B IMRB(A0),MFPMEM+3
 MOVE.B TADR(A0),MFPMEM+4
 MOVE.B TACR(A0),MFPMEM+5
 MOVE.B VECTOR(A0),MFPMEM+6
 RTS
OLDMFP:
 MOVE.L #MFP,A0
 MOVE.B MFPMEM+6,VECTOR(A0)
 MOVE.B MFPMEM+5,TACR(A0)
 MOVE.B MFPMEM+4,TADR(A0)
 MOVE.B MFPMEM+3,IMRB(A0)
 MOVE.B MFPMEM+2,IMRA(A0)
 MOVE.B MFPMEM+1,IERB(A0)
 MOVE.B MFPMEM,IERA(A0)
 RTS
SETINT:
 MOVE.W SR,D0
 MOVE.W #$2700,SR
 MOVE.L A0,ISRVEC
 MOVE.W D0,SR
 RTS
SETFREQ:
 MOVE.L #MFP,A1
 MOVE.B #0,TACR(A1)   ;DISABLE TIMER
 AND.W #7,D0          ;ENSURE 0-7
 LEA FREQTAB,A0       ;GET THE FREQUENCY XREF ADDR
 LSL.W #1,D0          ;CONVERT TO WORD TABLE OFFSET
 MOVE.W 0(A0,D0.W),D0 ;& GET THE MFP DATA
 MOVE.B D0,TACR(A1)   ;LSB = CONTROL REG BYTE
 LSR.W #8,D0          ;SHIFT DOWN NEXT BYTE
 MOVE.B D0,TADR(A1)   ;NEXT = DATA REG BYTE
 RTS
ENABMFP:
 MOVE.L #MFP,A0
 MOVE.B #$20,IMRA(A0)
 MOVE.B #0,IMRB(A0)
 MOVE.B #$20,IERA(A0)
 MOVE.B #0,IERB(A0)
 BCLR #3,VECTOR(A0)
 RTS
FREQTAB:
 DC.W $0506 ;4.9 KHZ
 DC.W $0505 ;7.68 KHZ
 DC.W $0405 ;9.6 KHZ
 DC.W $2901 ;14.99 KHZ
 DC.W $1F01 ;19.8 KHZ
 DC.W $0802 ;30.7 KHZ
 DC.W $0106
 DC.W $0106
SCREG=$FF8800
SCDATA=$FF8802
HBL2:
 DC.W $21FC     ;MOVE.L #SAMPLAY,$68.W
 DC.L SAMPLAY
 DC.W $68
 RTE
SAMPLAY:
 MOVE.L A0,-(SP)
 MOVE.L D0,-(SP)
 MOVE.W #$8800,A0
 CLR.W D0
 MOVE.B (A6)+,D0     ;READ FROM RAM
 LSL.W #3,D0         ;DOUBLE LONG WORD OFFSET
 MOVE.L MAD_SHOW+58+4(PC,D0.W),(A0)
 MOVE.L MAD_SHOW+58(PC,D0.W),D0
 MOVEP.L D0,0(A0)
 MOVE.L (SP)+,D0
 MOVE.L (SP)+,A0
 DC.W $21FC     ;MOVE.L #HBL2,$68.W
 DC.L HBL2
 DC.W $68
 RTE
MAD_SHOW:
 IBYTES MADSHOW.B
ZILCH:
 RTE
SETSND:
 MOVE.B #0,SCREG ;CHANNEL A
 MOVE.B #0,SCDATA
 MOVE.B #1,SCREG
 MOVE.B #0,SCDATA

 MOVE.B #2,SCREG ;CHANNEL B
 MOVE.B #0,SCDATA
 MOVE.B #3,SCREG
 MOVE.B #0,SCDATA

 MOVE.B #4,SCREG ;CHANNEL C
 MOVE.B #0,SCDATA
 MOVE.B #5,SCREG
 MOVE.B #0,SCDATA

 MOVE.B #7,SCREG ;SET UP CHANNEL MIXING & PORT 'A' I/O
 MOVE.B #$FF,SCDATA

 MOVE.B #8,SCREG ;SET ALL VOLUMES TO ZERO
 MOVE.B #0,SCDATA
 MOVE.B #9,SCREG
 MOVE.B #0,SCDATA
 MOVE.B #10,SCREG
 MOVE.B #0,SCDATA
 RTS
MFPMEM:
 DS.W 10
;************************************
;** END OF SAMPLE ROUTINES         **


;************************************
;** SPRITE CONTROL ROUTINES        **
;************************************
STYREX:         ;EXPLOSION HANDLER
 MOVE.L (A0),A1
 MOVEQ #0,D0
 MOVE.W (A1)+,D0
 BMI YXKILL
 ADD.L D0,4(A0)
 ADD.W #160*2,8(A0)
 MOVE.L A1,(A0)
 RTS
STYR3:            ;DUMMY VECTOR
 RTS
STYR2:
 MOVE.L (A0),A1   ;STYR TAB PEKARE
 MOVE.W (A1)+,D0  ;X COORD OR COMMAND
 BMI STR21        ;IF NEGATIVE THEN COMMAND
 MOVE.W (A1)+,D1  ;Y COORD
 MOVE.W D0,10(A0) ;NEW X
 MOVE.W D1,8(A0)  ;NEW Y
 MOVE.L A1,(A0)
 RTS
STR21:            ;COMMAND HANDLER
 CMP.W #-1,D0
 BEQ YXKILL
 CMP.W #-2,D0
 BEQ YXCHGRAF
 MOVE.L A1,(A0)
 RTS
YXCHGRAF:         ;CHANGE SPRITE GX
 MOVE.W (A1)+,D0
 ADD.W D0,4(A0)
 MOVE.L A1,(A0)
 RTS
YXKILL:           ;KILL SPRITE
 MOVE.L #0,-4(A0)
 RTS

STYR:
 LEA 10(A0),A1
; MOVE.B $FFFC02,D0
; CMP.B #$48,D0
; BEQ UP
; CMP.B #$50,D0
; BEQ DOWN
; CMP.B #$4B,D0
; BEQ LEFT
; CMP.B #$4D,D0
; BEQ RIGHT
; CMP.B #$39,D0
; BNE NOFIRE
 MOVE.B JOYREAD,D0
 BEQ NOSTYR
  MOVE.B D0,D1
  AND.B #%01110000,D1
  BNE NOSTYR
 BTST #0,D0
 BNE UP
 BTST #1,D0
 BNE DOWN
UDOWNB:
 BTST #2,D0
 BNE LEFT
 BTST #3,D0
 BNE RIGHT
LRIGHTB:
 BTST #7,D0
 BEQ NOFIRE
 BRA.S FIRE
NOFIRE:
 ST.B FIREFLAG     ;FIRE ENABLED
 RTS
NOSTYR:
 ST.B FIREFLAG
 MOVE.L #SPRITEGX,SPRITELIST+8
 RTS
FIRE:
 TST.B FIREFLAG
 BEQ FIR1
 CLR.B FIREFLAG
 BSR FINDFREESHOT
 TST.W D1
 BMI FIR1          ;NO FREE SHOTS FOUND
 MOVE.W #1,(A2)+   ;MOVEMENT FACTOR
 MOVE.W -2(A1),D0
 ADD.W #12*160,D0
 MOVE.W D0,(A2)    ;Y COORD*160
 MOVE.W (A1),D0
 ADDQ.W #1,D0
 ADD.W FIREADDX,D0
 NEG.W FIREADDX
 MOVE.W D0,2(A2) ;X COORD
FIR1:
 RTS
FIREADDX:
 DC.W 1

FIRE2:            ;2 SHOTS PER FIRE
 TST.B FIREFLAG
 BEQ FIR1
 CLR.B FIREFLAG
 BSR FINDFREESHOT
 TST.W D1
 BMI FIR1          ;NO FREE SHOTS FOUND
 MOVE.W #1,(A2)+   ;MOVEMENT FACTOR
 MOVE.W -2(A1),D0
 ADD.W #12*160,D0
 MOVE.W D0,(A2)    ;Y COORD*160
 MOVE.W (A1),D0
 ADDQ.W #2,D0
 MOVE.W D0,2(A2) ;X COORD
 BSR FINDFREESHOT
 TST.W D1
 BMI FIR1          ;NO FREE SHOTS FOUND
 MOVE.W #1,(A2)+   ;MOVEMENT FACTOR
 MOVE.W -2(A1),D0
 ADD.W #12*160,D0
 MOVE.W D0,(A2)    ;Y COORD*160
 MOVE.W (A1),D0
; ADDQ.W #1,D0
 MOVE.W D0,2(A2) ;X COORD
 RTS

FINDFREESHOT:
 LEA SHOTLIST-6,A2
 MOVEQ #11,D1
FIR2:
 ADDQ.W #6,A2
 TST.W (A2)
 DBEQ D1,FIR2
 RTS
RIGHT:
 CMP.W #47,(A1)
 BEQ NOSTYR
 ADDQ.W #1,(A1)
 MOVE.L #SPRITEGX+(4*384),SPRITELIST+8
 BRA LRIGHTB
LEFT:
 CMP.W #4,(A1)
 BEQ NOSTYR
 SUBQ.W #1,(A1)
 MOVE.L #SPRITEGX+(8*384),SPRITELIST+8
 BRA LRIGHTB
UP:
 CMP.W #32*160,-2(A1)
 BLE UDOWNB
 SUB.W #2*160,-2(A1)
 BRA UDOWNB
DOWN:
 CMP.W #184*160,-2(A1)
 BGE UDOWNB
 ADD.W #2*160,-2(A1)
 BRA UDOWNB
JOYREAD:
 DC.W 0
FIREFLAG:
 DC.W 0

JOYSTICK:            ;KEYBOARD INTERRUPT
 MOVE.W D0,-(SP)
 MOVE.B $FFFC02,D0
; TST.B JOYFLAG_0
; BNE.S JOY0

 TST.B JOYFLAG_1
 BNE.S JOY1

; CMP.B #$FE,D0
; BEQ.S JOYSTICK_0

 CMP.B #$FF,D0
 BEQ.S JOYSTICK_1
 MOVE.W (SP)+,D0
 BCLR #6,$FFFA11
 RTE
JOYSTICK_0:
 ST JOYFLAG_0
 MOVE.W (SP)+,D0
 BCLR #6,$FFFA11
 RTE
JOYFLAG_0:
 DC.B 0,0
JOYSTICK_1:
 ST JOYFLAG_1
 MOVE.W (SP)+,D0
 BCLR #6,$FFFA11
 RTE
JOYFLAG_1:
 DC.B 0,0
JOY0:
 SF JOYFLAG_0
 MOVE.W (SP)+,D0
 BCLR #6,$FFFA11
 RTE
JOY1:
 SF JOYFLAG_1
 MOVE.B D0,JOYREAD
 MOVE.W (SP)+,D0
 BCLR #6,$FFFA11
 RTE
;************************************
;** END OF CONTROL ROUTS           **

OKEY: DC.L 0,0
OHBL: DC.L 0
SPAR: DS.L 8,0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0
OMFP:
 DC.W 0
PAL:
 DC.W $000,$333,$555,$777,$020,$030,$040,$060
 DC.W $770,$740,$700,$200,$320,$750,$125,$237
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

MOUSE:
 DC.B $12,$14,$14,8

SCREENS:
 DC.L SCR1,SCR

CLOCK:
 DC.W 0,0

CANNSPECS:      ;HTIS,SHOTCOUNT,GX
 DC.W 0,0
 DC.L 0

 DC.W 5,$1010
 DC.L CANNONGX

 DC.W 2,$1010
 DC.L CANNONGX+512

BLOCKS:
; IBYTES LEVEL1.MAP
 DC.B 0,0,0,0,0,0, 1
 DC.B -2,0,0,0,2,0, 0
 DC.B 1,0,1,0,2,0, 0
 DC.B 0,0,0,-1,0,0, 0
 DC.B 1,1,1,1,1,1, 0
 DC.B 0,0,0,0,0,0, 0
 DC.B 2,2,2,2,2,2, 0
BLOCKSLUT:
 ALIGN.W

BLOCKGX:
 DS.B 512,0
 IBYTES BLOCKGX.DAT
BGXSLUT:

BADDS:
 DC.L BLOCKGX,BLOCKGX,BLOCKGX,BLOCKGX,BLOCKGX,BLOCKGX

EX16TAB:        ;EXPLOSION GRAFIX OFFSET TABEL
 DS.W 2,0
 DC.W 384*4
 DS.W 2,0
 DC.W 384*4
 DS.W 5,0
 DC.W 384*4
 DS.W 2,0
 DC.W 384*4
 DS.W 2,0
 DC.W 384*4
 DS.W 2,0
 DC.W -1
EX32TAB:        ;EXPLOSION GRAFIX OFFSET TABEL
 DS.W 2,0
 DC.W 1152*4
 DS.W 2,0
 DC.W 1152*4
 DS.W 2,0
 DC.W 1152*4
 DS.W 3,0
 DC.W 1152*4
 DS.W 5,0
 DC.W 1152*4
 DS.W 4,0
 DC.W 1152*4
 DS.W 3,0
 DC.W 1152*4
 DS.W 2,0
 DC.W -1

SHOTGX:      ;HERO SHOTS
 IBYTES SHOTGX.DAT

SHOTLIST:    ;FLAG,Y,X
 DS.W 12*3

OBSTXY:      ;FLAG,Y,X
 DS.W 14*3

SPRITELIST:  ;STYR,STYRTAB,GRAF,Y,X
 DC.L STYR,0,SPRITEGX
 DC.W 50*160,20
 DS.B 8*16

SPRITELIST32: ;STYR,STYRTAB,GRAF,W:Y,W:X,W:HITS
 DS.B 4*18

CANNTAB:      ;W:HITS,B:SHOTS,B:SHOTS DEF,L:GX,W:YADD,W:XCOORD,L:DUMMY
 DS.B 10*16

WAVE1:
 DC.W 1
 DC.L STYR2,MOVE2,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 1
 DC.L STYR2,MOVE1,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 1
 DC.L STYR2,MOVE1,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 1
 DC.L STYR2,MOVE1,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 1
 DC.L STYR2,MOVE1,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 1
 DC.L STYR2,MOVE1,SPRITEGX+(36*384)
 DC.W 3,2
 DC.W 2
 DC.L STYR2,MOVE2,SPRITEGX32
 DC.W 5
 DC.W 0

WAVE2:
 DC.W 2
 DC.L STYR2,MOVE2,SPRITEGX32
 DC.W 10
 DC.W 0

MOVE1:
 DC.W 8,10*160  ,8,14*160
 DC.W 8,18*160  ,8,20*160
 DC.W 8,24*160  ,8,28*160
 DC.W 8,32*160  ,8,36*160
 DC.W 9,40*160  ,10,44*160
 DC.W 11,48*160 ,12,52*160
 DC.W 13,56*160 ,14,60*160
 DC.W 15,64*160 ,16,68*160
 DC.W 17,72*160 ,18,76*160
 DC.W 18,80*160 ,18,80*160
 DC.W 18,80*160 ,18,80*160
 DC.W 18,80*160 ,18,80*160
 DC.W -1

MOVE2:
 IBYTES MOVE2.TAB
 DC.W -1

CANNONGX:
 IBYTES CANNONGX.DAT

SAMPLE:
 IBYTES HANDM2.SPL
SAMPSLUT:
 IBYTES HANDM2.SPL,200

SPRITEGX:
 IBYTES SPRITES.DAT

SPRITES32:
 IBYTES SPRITE32.DAT

SPRITEGX32 EQU SPRITEGX+(NOSPR*1536)

ENDLABEL:
TEMP EQU ENDLABEL+100000
 END

 